/*
 
 Copyright (c) 2004 PXI Project Team
 
 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in the
 Software without restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
 Software, and to permit persons to whom the Software is furnished to do so,
 subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in all copies
 or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 
 */

//  PXICodeMixer.mm
//  PXICodeMixer
//
//  last changed by: creysoft

#import "PXICodeMixer.h"
#include <iostream>
#include <cstring>
#include <string>
#include <sstream>
#include <stack>
#include <vector>
#include <map>
#include "cute_tokenizer.h"
#include "variant.h"
#include "bchasm.h"
#include "quotesrecord.h"
#include "PXIHyperTalkCompiler.h";

@implementation PXICodeMixer

+ (NSString *)doMix:(NSString *)mixWhat
{
	string s = [mixWhat cString];
	
	PXIHyperTalkCompiler compiler;
	bchasm interpreter;
	
	s = compiler.compile( s );
	compiler.echo();
	interpreter.assemble( s );
	//interpreter.echomap();
	//interpreter.echojumps();
	interpreter.interpret();
	s = interpreter.standard_out;
	
	return [NSString stringWithCString:s.c_str()];
}

@end
